<?php

use App\Http\Controllers\Admin\Banner\BannerController;
use App\Http\Controllers\Admin\Brand\BrandController;
use App\Http\Controllers\Admin\Category\CategoryChildController;
use App\Http\Controllers\Admin\Category\CategoryController;
use App\Http\Controllers\Admin\Common\CommonController;
use App\Http\Controllers\Admin\Common\DonationController;
use App\Http\Controllers\Admin\Common\FaqController;
use App\Http\Controllers\Admin\Complints\ComplintController;
use App\Http\Controllers\Admin\Customer\CustomerController;
use App\Http\Controllers\Admin\Customer\CustomerEmailController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\Deal\DealController;
use App\Http\Controllers\Admin\Deal\DealProductController;
use App\Http\Controllers\Admin\Delivery\DeliveryController;
use App\Http\Controllers\Admin\Delivery\DeliveryPartnerController;
use App\Http\Controllers\Admin\Order\OrderAssignController;
use App\Http\Controllers\Admin\Order\OrderController;
use App\Http\Controllers\Admin\Order\OrderDeliveryController;
use App\Http\Controllers\Admin\Package\BasketController;
use App\Http\Controllers\Admin\Package\PackageController;
use App\Http\Controllers\Admin\Package\PackageGroupController;
use App\Http\Controllers\Admin\Package\PackageProductController;
use App\Http\Controllers\Admin\Payout\PayoutController;
use App\Http\Controllers\Admin\Pincode\PincodeController;
use App\Http\Controllers\Admin\Product\ProductController;
use App\Http\Controllers\Admin\Product\ProductRequirementController;
use App\Http\Controllers\Admin\Product\ProductSearchController;
use App\Http\Controllers\Admin\Product\ProductVariantController;
use App\Http\Controllers\Admin\Profile\ProfileController;
use App\Http\Controllers\Admin\Reviews\ReviewController;
use App\Http\Controllers\Admin\Slider\SliderChildController;
use App\Http\Controllers\Admin\Slider\SliderController;
use App\Http\Controllers\Admin\Vendor\VendorController;
use App\Http\Controllers\Admin\Vendor\VendorProductController;
use App\Http\Controllers\Admin\Wallet\WalletController;
use App\Http\Controllers\Auth\LoginController;
use App\Mail\OrderShipped;
use App\Models\Orders\Order;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::view('/', 'app');
Route::get('privacy', [\App\Http\Controllers\Front\Common\CommonController::class, 'privacy']);
Route::get('terms', [\App\Http\Controllers\Front\Common\CommonController::class, 'terms']);
Route::view('password/reset/success', 'auth.passwords.success');

Auth::routes();

Route::middleware('role:admin')->prefix('admin')->group(function () {

    // Dashboard
    Route::get('dashboard', [DashboardController::class, 'index'])->name('home');

    // Orders
    Route::get('orders/{order}/assign', [OrderAssignController::class, 'show'])->name('orders.assign.show');
    Route::post('orders/{order}/assign', [OrderAssignController::class, 'update'])->name('orders.assign');
    Route::get('orders/{order}/deliveries', [OrderDeliveryController::class, 'index'])->name('orders.deliveries');
    Route::resource('orders', OrderController::class)->only(['index', 'edit', 'destroy', 'update']);

    // Customer
    Route::get('customers/{customer}/email', [CustomerEmailController::class, 'show'])->name('customers.email.show');
    Route::post('customers/{customer}/email', [CustomerEmailController::class, 'send'])->name('customers.email.send');
    Route::resource('customers', CustomerController::class)->except('show');

    // Categories
    Route::resource('categories', CategoryController::class);
    Route::resource('categories.child', CategoryChildController::class);

    // Products
    Route::get('products/requirements', [ProductRequirementController::class, 'index'])->name('product.requirements.index');
    Route::delete('products/requirements/{requirement}', [ProductRequirementController::class, 'destroy'])->name('product.requirements.destroy');
    Route::post('products/requirements', [ProductRequirementController::class, 'store'])->name('product.requirements.store');
    Route::resource('products-search', ProductSearchController::class)->only(['index', 'destroy']);

    Route::get('products/{product}/variant', [ProductVariantController::class, 'edit'])->name('products.variant');
    Route::post('products/{product}/variant', [ProductVariantController::class, 'update'])->name('products.variant.update');

    Route::resource('products', ProductController::class)->except('show');

    Route::resource('vendors.products', VendorProductController::class)->only('index');
    Route::resource('vendors', VendorController::class)->except('show');

    // Brand
    Route::resource('brands', BrandController::class)->except('show');

    // Deal
    Route::get('deals/{deal}/products', [DealProductController::class, 'edit'])->name('deals.products');
    Route::post('deals/{deal}/products', [DealProductController::class, 'update'])->name('deals.products.update');
    Route::resource('deals', DealController::class)->except('show');

    // Banners
    Route::get('banner', [BannerController::class, 'index'])->name('banner.index');
    Route::patch('banner/{banner}', [BannerController::class, 'update'])->name('banner.update');

    // Slider Resource
    Route::resource('sliders', SliderController::class);
    Route::resource('sliders.child', SliderChildController::class)->except(['show', 'index']);

    // Pin code Resource
    Route::resource('pincodes', PincodeController::class)->except('show');

    // Delivery Resource
    Route::resource('deliveries', DeliveryController::class)->only(['index', 'edit', 'update', 'destroy']);
    Route::resource('delivery-partners', DeliveryPartnerController::class)
        ->parameters(['delivery-partners' => 'partner'])
        ->except('show');

    // wallet Resource
//    Route::resource('wallets', WalletController::class)->except('show');
    Route::get('wallets/{user}', [WalletController::class, 'show'])->name('wallets.index');
    Route::post('wallets/{wallet}/recharge', [WalletController::class, 'recharge'])->name('wallets.recharge');
    Route::post('wallets/{wallet}/coupon', [WalletController::class, 'coupon'])->name('wallets.coupon');
    Route::post('wallets/{wallet}/debt', [WalletController::class, 'debt'])->name('wallets.debt');
    Route::post('wallets/{wallet}/package', [WalletController::class, 'package'])->name('wallets.package');

    // packages Resource
    Route::get('packages/{package}/product', [PackageProductController::class, 'edit'])->name('packages.product');
    Route::post('packages/{package}/product', [PackageProductController::class, 'update'])->name('packages.product.update');
    Route::resource('packages/group', PackageGroupController::class)->except('show');
    Route::resource('packages', PackageController::class)->except('show');

    // Basket
    Route::resource('basket', BasketController::class)->except('show');

    Route::resource('payouts', PayoutController::class)->except('show');

    // Review Resource
    Route::resource('reviews', ReviewController::class)->except('show');

    // Complints Resource
    Route::resource('complints', ComplintController::class)->except('show');

    // Profile
    Route::resource('profile', ProfileController::class)->only(['edit', 'update']);

    // Donation
    Route::resource('donations', DonationController::class)->except('show');

    // Commons
    Route::prefix('common')->name('common.')->group(function () {
        Route::resource('faqs', FaqController::class)->except('show');

        Route::get('privacy', [CommonController::class, 'privacy'])->name('privacy.show');
        Route::post('privacy', [CommonController::class, 'updatePrivacy'])->name('privacy.update');

        Route::get('terms', [CommonController::class, 'terms'])->name('terms.show');
        Route::post('terms', [CommonController::class, 'updateTerms'])->name('terms.update');

        Route::get('about', [CommonController::class, 'about'])->name('about.show');
        Route::post('about', [CommonController::class, 'updateAbout'])->name('about.update');

        Route::get('shipping', [CommonController::class, 'shipping'])->name('shipping.show');
        Route::post('shipping', [CommonController::class, 'updateShipping'])->name('shipping.update');

        Route::get('refund', [CommonController::class, 'refund'])->name('refund.show');
        Route::post('refund', [CommonController::class, 'updateRefund'])->name('refund.update');
    });

    Route::get('logout', [LoginController::class, 'logout'])->name('admin.logout');
});

Route::get('/symlink', function () {
    Artisan::call('storage:link');
});

Route::get('/clear', function () {

    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('config:cache');
    Artisan::call('view:clear');

    return "Cleared!";
});

Route::get('email', function () {
    $id = request('id');
    $email = request('email');

    $order = Order::query()->find($id ?? 4);

    if (isset($email)) {
        Mail::to($email)->send(new OrderShipped($order));
    }

    return view('email.order', compact('order'));
});
