<?php

use App\Http\Controllers\API\Auth\VendorAuthController;
use App\Http\Controllers\API\Vendor;
use Illuminate\Support\Facades\Route;

Route::post('login', [VendorAuthController::class, 'login']);
Route::post('register', [VendorAuthController::class, 'register']);


Route::middleware(['auth:sanctum', 'type.vendor'])->group(function () {

    // Home
    Route::get('home', [Vendor\Home\HomeController::class, 'index']);

    Route::get('brands', [Vendor\Brand\BrandController::class, 'index']);
    Route::get('categories', [Vendor\Category\CategoryController::class, 'index']);

    Route::get('requirements', [Vendor\Requirement\RequirementController::class, 'index']);
    Route::post('requirements', [Vendor\Requirement\RequirementController::class, 'store']);

    Route::get('products', [Vendor\Product\ProductController::class, 'index']);
    Route::post('products', [Vendor\Product\ProductController::class, 'store']);

    Route::get('invoices', [Vendor\Invoice\InvoiceController::class, 'index']);
    Route::get('invoices/{id}', [Vendor\Invoice\InvoiceController::class, 'show']);

    Route::post('delivery/{delivery}/update', [Vendor\Invoice\DeliveryController::class, 'update']);

    Route::get('partners', [Vendor\Invoice\DeliveryPartnerController::class, 'index']);
    Route::post('partners', [Vendor\Invoice\DeliveryPartnerController::class, 'store']);

    //Wallet
    Route::get('wallet', [Vendor\Wallet\WalletController::class, 'show']);
    Route::get('wallet/coupon', [Vendor\Wallet\WalletController::class, 'coupon']);
    Route::post('wallet/reserve', [Vendor\Wallet\WalletController::class, 'reserve']);
    Route::post('wallet/transfer', [Vendor\Wallet\WalletController::class, 'transfer']);

    Route::get('logout', [VendorAuthController::class, 'logout']);
});
