@props(['id', 'name' => 'image', 'label', 'img' => null, 'required' => true])

<div class="form-group">
    <label for="{{ $id }}">{{ $label }}</label>
    <div class="input-group">
        <div class="custom-file">
            <input onchange="callShow('{{ $id }}', '{{ $img }}')" type="file" class="custom-file-input @error($name)is-invalid @enderror" id="{{ $id }}" name="{{ $name }}" {{ $required? 'required': '' }}>
            <label class="custom-file-label" for="{{ $id }}">Choose file</label>
        </div>
    </div>
    @if($errors->has($name))
    <div style="width: 100%;margin-top: .25rem;font-size: 80%;color: #dc3545;">
        {{ $errors->first($name) }}
    </div>
    @endif
</div>