@extends('layouts.admin')

@section('title', $wallet->user->name.'\'s Wallet')

@section('content')
    @can('wallet')
        <div class="row">
            <div class="col-md-3">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ $wallet->balance['currency'] }}</h3>
                        <p>Balance</p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>{{ $wallet->reserve['currency'] }}</h3>
                        <p>Reserve</p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $wallet->max_debt['currency'] }}</h3>
                        <p>Max Debt</p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $wallet->coupon['currency'] }}</h3>
                        <p>Coupon</p>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3>{{ $wallet->debt['currency'] }}</h3>
                        <p>Debt</p>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $wallet->package['currency'] }}</h3>
                        <p>Package</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <form method="POST" action="{{ route('wallets.recharge', $wallet->id) }}">
                                    @csrf
                                    <x-input-form type="number" id="recharge" name="amount"
                                                  label="Recharge Customer"></x-input-form>

                                    <button type="submit" class="btn btn-block btn-primary">Recharge</button>
                                </form>
                            </div>

                            <div class="col-md-6">
                                <form method="POST" action="{{ route('wallets.coupon', $wallet->id) }}">
                                    @csrf
                                    <x-input-form type="number" id="blnc" name="amount" label="Send Coupon"></x-input-form>

                                    <button type="submit" class="btn btn-block btn-info">Send Coupon</button>
                                </form>
                            </div>

                            <div class="col-md-6 mt-2">
                                <form method="POST" action="{{ route('wallets.debt', $wallet->id) }}">
                                    @csrf
                                    <x-input-form type="number" id="blnc" name="amount"
                                                  label="Set Max Allowed Debt"></x-input-form>

                                    <button type="submit" class="btn btn-block btn-warning">SET</button>
                                </form>
                            </div>

                            <div class="col-md-6 mt-2">
                                <form method="POST" action="{{ route('wallets.package', $wallet->id) }}">
                                    @csrf
                                    <x-input-form type="number" id="blnc" name="amount"
                                                  label="Transfer Package To Coupon"></x-input-form>

                                    <button type="submit" class="btn btn-block btn-warning">TRANSFER</button>
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">Customer Details</div>
                        <div class="card-text">
                            <dl>
                                <dt>Name</dt>
                                <dd>{{ $wallet->user->name }}</dd>

                                <dt>Email</dt>
                                <dd>{{ $wallet->user->email }}</dd>

                                <dt>Mobile</dt>
                                <dd>{{ $wallet->user->phone }}</dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="card-title">Transactions</div>
                <div class="card-text">
                    <livewire:wallet.transactions-table :walletId="$wallet->id"></livewire:wallet.transactions-table>
                </div>
            </div>
        </div>
    @else
        <h2>You Do Not Have Permission</h2>
    @endcan
@endsection
