@extends('layouts.admin')

@section('title', 'Update Vendors')

@section('content')
<div class="card">
    <form method="POST" action="{{ route('vendors.update', $vendor->id)}}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="card-body">

            <div class="row">
                <div class="col-md-6">
                    <x-input-form id="name" name="name" label="Name" :value="$vendor->name" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="email" name="email" type="email" label="Email" :value="$vendor->email" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="phone" name="phone" type="text" label="Phone" :value="$vendor->phone" />
                </div>


                <div class="col-md-6">
                    <x-input-form :required="false" id="password" name="password" type="text" label="Password"/>
                </div>



            </div>
        </div>


        <x-btn-submit :update="true" />

    </form>
</div>

@endsection
