@extends('layouts.admin')

@section('title', 'All Titles')

@section('action')
<x-btn-insert :route="route('sliders.create')" title="Add Title" />
@endsection
@section('content')

<div class="card mt-4">

   
    <!-- /.card-header -->
    <div class="card-body table-responsive">
        <table id="example" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="50%">Name</th>
                    <th width="10%">Status</th>
                    <th width="10%">Action</th>

                </tr>
            </thead>
            <tbody>
                @foreach($sliders as $slider)
                <tr>
                    <td>{{$slider->id}}</td>
                    <td>
                        {{$slider->name}}
                    </td>

                    <td>
                        <a href="{{ route('sliders.show',$slider->id)}}" style="color: #fff;"
    class="btn btn-sm btn-info">
    <i class="far fa-eye"></i>
    VIEW Image
</a>
                    </td>

                    <td>
                        <div style="float: left; margin-right: 5px;">
                            <a href="{{ route('sliders.edit', $slider->id) }}" style="color: #fff;"
                                class="btn btn-sm btn-primary">
                                <i class="fa fa-edit"></i>
                            </a>
                        </div>

                        <div style="float: left;">
                            <a href="{{ route('sliders.destroy', $slider->id) }}" data-method="DELETE"
                                data-confirm="Are you sure?" data-title="Please confirm this action"
                                data-theme="sweetalert">
                                <i class="fa fa-trash btn btn-sm btn-danger" style="color: #fff;"></i>
                            </a>
                        </div>

                        <div class="clearfix"></div>
                    </td>

                </tr>

                @endforeach


            </tbody>

        </table>
    </div>


    <!-- /.card-body -->
</div>

<script>
  $(document).ready( function () {
      $('#example').DataTable();
  } );
</script>

@endsection