@extends('layouts.admin')

@section('title', 'All Product Requirements')

@section('content')
    <div class="row" x-data="data()">
        <div class="col-md-12">
            <button class="btn btn-primary" data-toggle="modal" data-target="#myModal">Add Product</button>
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    {!! $dataTable->table() !!}
                </div>
            </div>
        </div>

        <!-- Product Modal -->
        <div class="modal" id="myModal">
            <div class="modal-dialog modal-lg modal-dialog-scrollable">
                <div class="modal-content">
                    <!-- Modal Header -->
                    <div class="modal-header">
                        <h4 class="modal-title">All Product</h4>
                        <button @click="toggle()" type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>

                    <!-- Modal body -->
                    <div class="modal-body">
                        <div x-show="step == true">
                            <table id="products-table" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">Product Name</th>
                                    <th width="10%">Image</th>
                                    <th width="10%">Select</th>
                                </tr>
                                </thead>
                                <tbody>
                                <template x-for="product in products">
                                    <tr>
                                        <td x-text="product.id"></td>
                                        <td x-text="product.name"></td>
                                        <td>
                                            <img :src="'/storage/'+product.image"
                                                 style="height: 30px; margin-bottom: 5px; border-radius: 4px;">
                                        </td>
                                        <td>
                                            <button @click="selectProduct(product)" type="button"
                                                    class="btn btn-primary">Select
                                            </button>
                                        </td>
                                    </tr>
                                </template>
                                </tbody>
                            </table>
                        </div>

                        <div x-show="step == false">
                            <table class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="10%">Unit</th>
                                    <th width="10%">MRP</th>
                                    <th width="10%">SELECT</th>
                                </tr>
                                </thead>
                                <tbody>
                                <template x-for="variant in variants">
                                    <tr>
                                        <td x-text="variant.id"></td>
                                        <td x-text="variant.unit"></td>
                                        <td class="text-red" x-text="'₹'+variant.mrp.amount"></td>
                                        <td>
                                            <button @click="selectVariation(variant)" data-dismiss="modal" type="button"
                                                    class="btn btn-block btn-outline-primary">Add
                                            </button>
                                        </td>
                                    </tr>
                                </template>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    {!! $dataTable->scripts() !!}

    <script>
        $(function () {
            $('#products-table').DataTable();
        });

        function data() {
            return {
                products: @json($products),
                selected: [],
                step: true,
                prod: {},
                variants: [],

                selectProduct(product) {
                    this.prod = product;

                    if (this.prod.variants == null) {
                        toastr.error(product.name + ' does not have any variants!');
                        return;
                    }

                    this.variants = this.prod.variants;

                    this.step = false;
                },

                selectVariation(variant) {
                    const isAdded = this.selected.find(x => x.variant_id === variant.id);

                    if (isAdded != null) {
                        Swal.fire({
                            title: 'Variant Already Exists!',
                            text: 'Please Select Another Variant',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }

                    const item = {
                        product_id: this.prod.id,
                        variant_id: variant.id,
                    };

                    this.selected.push(item);

                    this.prod = {};
                    this.variants = [];
                    this.step = true;
                    this.submit();
                },

                submit() {
                    const route = '{{ route('product.requirements.store') }}';

                    axios
                        .post(route, this.selected[0])
                        .then(() => {
                            this.selected = [];
                            window.location.reload();
                        });
                },

                toggle() {
                    this.step = true;
                }
            };
        }
    </script>
@endpush
