@extends('layouts.admin')

@section('title', 'Edit Product')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('products.update',$product->id)}}" enctype="multipart/form-data">
            @csrf
            @method('PATCH')
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 text-center mb-5">
                        <img id="imgProduct" src="{{  Storage::url($product->image) }}"
                             style="height: 100px; border-radius: 4px;">
                    </div>

                    <div class="col-md-6">
                        <x-input-file id="inputProduct" label="Select a Image" img="imgProduct" :required="false"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-form id="name" name="name" label="Product Name" :value="$product->name"/>
                    </div>

                    <div class="col-md-12">
                        <x-input-select label="Brand" name="brand_id" id="brand" :disabled="false">
                            @foreach($brand as $values)
                                <option
                                    value="{{$values->id}}" {{$values->id == $product->brand_id ? 'selected' : '' }}>
                                    {{$values->name}}
                                </option>
                            @endforeach
                        </x-input-select>
                    </div>

                    <livewire:category-select :category-id="$product->category_id"
                                              :subcategory-id="$product->subcategory_id"></livewire:category-select>

                    <div class="col-md-6">
                        <x-input-select :disabled="false" :required="false" label="Place (Where you want to show?)"
                                        name="place"
                                        id="place">
                            <option value="home1" {{$product->place== 'home1' ? 'selected' : ''}}>
                                Home Screen 1
                            </option>
                            <option value="home2" {{$product->place== 'home2' ? 'selected' : ''}}>
                                Home Screen 2
                            </option>
                            <option value="home3" {{$product->place== 'home3' ? 'selected' : ''}}>
                                Home Screen 3
                            </option>
                            <option value="category" {{$product->place== 'category' ? 'selected' : ''}}>
                                Category Screen
                            </option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="In Stock" name="in_stock" id="inStock">
                            <option value="1" {{$product->in_stock== true ? 'selected' : ''}}>In Stock</option>
                            <option value="0" {{$product->in_stock== false ? 'selected' : ''}}>Out Of Stock</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :value="$product->sort" :required="false" type="number" id="sort" name="sort"
                                      label="Sort"/>
                    </div>

                    <div class="col-md-6">
                        <x-status :value="$product->status"/>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="descripion">Product Description</label>
                        <textarea class="@error('description')is-invalid @enderror" name="description" id="descripion">
              {{ $product->description }}
            </textarea>
                        @error('description')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>

                    <input type="hidden" name="url" value="{{ url()->previous() }}">
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary" onclick="return checksubmits()">Update</button>
            </div>

        </form>
    </div>
@endsection
