@extends('layouts.admin')

@section('title', 'Edit Payout Request')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <form action="{{ route('payouts.update', $payout->id) }}" method="POST">
                @csrf
                @method('PATCH')
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">Status</div>

                        <div class="card-text">
                            <div class="form-group">
                                <select name="status" id="status"
                                        class="custom-select @error('status')is-invalid @enderror">
                                    <option value="">Select Status</option>
                                    @foreach ($status as $item)
                                        <option value="{{ $item}}" @if($item == $payout->status) selected @endif>
                                            {{ Str::upper($item) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('status')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary" style="float: right;">Change Status</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Details</div>
                    <div class="card-text">
                        <dl>
                            <dt>Name</dt>
                            <dd>{{ $payout->name }}</dd>

                            <dt>Account</dt>
                            <dd>{{ $payout->account }}</dd>

                            <dt>IFSC</dt>
                            <dd>{{ $payout->ifsc }}</dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
