@extends('layouts.admin')

@section('title', 'Edit Package Group')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('group.update', $group->id) }}">
            @csrf
            @method('PATCH')
            <div class="card-body">
                <div class="row">

                    <div class="col-md-6">
                        <x-input-form :value="$group->name" id="name" name="name" label="Package Name"/>
                    </div>


                    <div class="col-md-6">
                        <x-input-form :required="false" :value="$group->sort" type="number" id="sort" name="sort" label="Sort"/>
                    </div>

                    <div class="col-md-12">
                        <x-status :value="$group->status"/>
                    </div>

                </div>
            </div>

            <x-btn-submit :update="true"/>
        </form>
    </div>
@endsection
