@extends('layouts.admin')

@section('title', 'Create Package')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('packages.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">

                    <div class="row col-md-12">
                        <div class="col-md-6">
                            <img id="imgPackage" src="{{ env('BLANK_IMAGE') }}"
                                 style="height: 100px; border-radius: 4px;">
                        </div>
                        <div class="col-md-6">
                            <img id="imgBanner" src="{{ env('BLANK_IMAGE') }}"
                                 style="height: 100px; border-radius: 4px;">
                        </div>
                    </div>

                    <div class="row col-md-12">
                        <div class="col-md-6">
                            <x-input-file id="filePackage" label="Select Package Image" img="imgPackage"/>
                        </div>
                        <div class="col-md-6">
                            <x-input-file name="banner" id="fileBanner" label="Select Package Banner" img="imgBanner"/>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <x-input-form id="name" name="name" label="Package Name"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Package Duration" name="duration" id="duration">
                            <option value="7">7 Days</option>
                            <option value="30">30 Days</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Package Group" name="group_id" id="group_id">
                            @foreach(\App\Models\Packages\PackageGroup::all() as $group)
                                <option value="{{ $group->id }}">{{ $group->name }}</option>
                            @endforeach
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-status/>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Duscount Type" name="discount_type" id="discountType">
                            <option value="none">No Discount</option>
                            <option value="flat">Flat Discount</option>
                            <option value="percentage">Percentage Discount</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :required="false" type="number" id="discount" name="discount"
                                      label="Discount Amount"/>
                    </div>

                    <div class="col-md-12 form-group">
                        <label for="descripion">Package Description</label>
                        <textarea class="@error('description')is-invalid @enderror" name="description"
                                  id="descripion"></textarea>
                        @error('description')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>

                </div>
            </div>

            <x-btn-submit/>
        </form>
    </div>
@endsection
