@extends('layouts.admin')

@section('title', 'Create Deals')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('deals.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">


                    <div class="col-md-6">
                        <x-input-form id="name" name="name" label="Name"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-select :disabled="false" :required="false" label="Place (Where you want to show?)"
                                        name="place"
                                        id="place">
                            <option value="home">Home Screen</option>
                            <option value="category">Category Screen</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :required="false" type="number" id="sort" name="sort" label="Sort" value="0"/>
                    </div>

                    <div class="col-md-6">
                        <x-status/>
                    </div>

                </div>

            </div>

            <x-btn-submit/>

        </form>
    </div>
@endsection
