@extends('layouts.admin')

@section('title', 'Send Email')

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <form action="{{ route('customers.email.send', $customer->id) }}" method="POST">
                    @csrf

                    <div class="card-body">
                        <x-input-form id="subject" name="subject" label="Subject"></x-input-form>

                        <div class="form-group">
                            <label for="descripion">Message</label>
                            <textarea class="form-control @error('message')is-invalid @enderror" name="message"
                                      id="descripion" rows="3"></textarea>
                            @error('message')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                        <input type="hidden" name="url" value="{{ url()->previous() }}">
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-success btn-block">SEND</button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Customer Details</div>
                    <div class="card-text">
                        <dl>
                            <dt>Name</dt>
                            <dd>{{ $customer->name }}</dd>

                            <dt>Email</dt>
                            <dd>{{ $customer->email }}</dd>

                            <dt>Mobile</dt>
                            <dd>{{ $customer->phone }}</dd>

                            <dt>Due</dt>
                            <dd>
                                <span class="text-red">{{ $customer->wallet->debt['currency'] }}</span>
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
