@extends('layouts.admin')

@section('title', 'Create Donation')

@section('content')
    <div class="card">

        <form method="POST" action="{{ route('donations.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">

                    <div class="col-md-12 text-center mb-5">
                        <img id="imgProduct" src="{{ env('BLANK_IMAGE') }}" style="height: 100px; border-radius: 4px;">
                    </div>

                    <div class="col-md-6">
                        <x-input-file id="inputProduct" label="Select a Image" img="imgProduct"/>
                    </div>

                    <div class="col-md-6">
                        <x-input-form id="title" name="title" label="Title"/>
                    </div>

                    <div class="col-md-6 form-group">
                        <label for="descripion">About</label>
                        <textarea class="@error('about')is-invalid @enderror" name="about" id="descripion"></textarea>
                        @error('about')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>

                    <div class="col-md-6 form-group">
                        <label for="important">Important</label>
                        <textarea class="@error('important')is-invalid @enderror"
                                  name="important"
                                  id="important">
                        </textarea>
                        @error('important')
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>

                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-success  btn-block">CREATE</button>
            </div>
        </form>
    </div>
@endsection

@push('scripts')
    <script>
        tinymce.init({
            selector: '#important',
            menubar: false,
            plugins: "code advlist autolink link image lists charmap print preview",
            toolbar: "code | newdocument | bold | italic | underline | strikethrough | alignleft | aligncenter | alignright | alignjustify | bullist | numlist | outdent | indent | blockquote | removeformat | subscript | superscript",
            a_plugin_option: false,
            a_configuration_option: 400
        });
    </script>
@endpush
