@extends('layouts.admin')

@section('title', 'Edit Subcategory')

@section('content')
<div class="card">
    <form method="POST" action="{{ route('categories.child.update', [$category->id, $child->id]) }}"
        enctype="multipart/form-data">
        @csrf
        @method('PATCH')

        <div class="card-body">
            <div class="row">
                <div class="col-md-12 text-center mb-5">
                    <img id="imgProduct" src="{{ Storage::url($child->image) }}"
                        style="height: 100px; border-radius: 4px;">
                </div>

                <div class="col-md-6">
                    <x-input-file :required="false" id="inputProduct" label="Select a Image" img="imgProduct" />
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$child->name" id="name" name="name" label="Category Name" />
                </div>

                <div class="col-md-12">
                    <x-status :value="$child->status" />
                </div>
            </div>
        </div>


        <x-btn-submit :update="true"/>

    </form>
</div>
@endsection