@extends('layouts.admin')

@section('title', 'Edit Brand')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('brands.update', $brand->id) }}" enctype="multipart/form-data">
            @csrf
            @method('PATCH')

            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <img id="imageBrand" src="{{ Storage::url($brand->image) }}"
                             style="height: 100px; border-radius: 4px;">
                    </div>

                    <div class="col-md-12">
                        <x-input-file :required="false" id="image" label="Select Brand Image"
                                      img="imageBrand"></x-input-file>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :value="$brand->name" id="name" name="name" label="Brand Name"></x-input-form>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Type" name="type" id="type">
                            <option value="brand" {{ $brand->type == 'brand' ? 'selected': '' }}>
                                Brand
                            </option>
                            <option value="sponsor" {{ $brand->type == 'sponsor' ? 'selected': '' }}>
                                Sponsor
                            </option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form :value="$brand->sort" type="number" id="sort" name="sort" label="Sort"/>
                    </div>

                    <div class="col-md-6">
                        <x-status :value="$brand->status"></x-status>
                    </div>
                </div>
            </div>


            <x-btn-submit :update="true"></x-btn-submit>

        </form>
    </div>
@endsection
