@extends('layouts.admin')

@section('title', 'Create Brand')

@section('content')
    <div class="card">
        <form method="POST" action="{{ route('brands.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 text-center">
                        <img id="imageBrand" src="{{ env('BLANK_IMAGE') }}" style="height: 100px; border-radius: 4px;">
                    </div>

                    <div class="col-md-12">
                        <x-input-file id="image" label="Select Brand Image" img="imageBrand"></x-input-file>
                    </div>

                    <div class="col-md-6">
                        <x-input-form id="name" name="name" label="Brand Name"></x-input-form>
                    </div>

                    <div class="col-md-6">
                        <x-input-select label="Type" name="type" id="type">
                            <option value="brand">Brand</option>
                            <option value="sponsor">Sponsor</option>
                        </x-input-select>
                    </div>

                    <div class="col-md-6">
                        <x-input-form type="number" id="sort" name="sort" label="Sort"/>
                    </div>

                    <div class="col-md-6">
                        <x-status/>
                    </div>

                </div>


            </div>

            <x-btn-submit></x-btn-submit>

        </form>
    </div>
@endsection
