@extends('layouts.admin')

@section('title', 'Update Basket Plan')

@section('content')
<div class="card">
    <form method="POST" action="{{ route('basket.update', $basket->id) }}" enctype="multipart/form-data">
        @csrf
        @method('PATCH')
        <div class="card-body">
            <div class="row">

                <div class="col-md-12 text-center mb-5">
                    <img id="imgProduct" src="{{ Storage::url($basket->image) }}"
                        style="height: 100px; border-radius: 4px;">
                </div>

                <div class="col-md-6">
                    <x-input-file :required="false" id="inputProduct" label="Select a Image" img="imgProduct" />
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$basket->name" id="name" name="name" label="Name" />
                </div>

                <div class="col-md-6">
                    <x-input-select label="Duration" name="duration" id="duration">
                        <option value="7" {{$basket->duration == '7' ? 'selected' : ''}}>7 Days</option>
                        <option value="30" {{$basket->duration == '30' ? 'selected' : ''}}>30 Days</option>
                    </x-input-select>
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$basket->min_amount" type="number" id="mrp" name="min_amount" label="Min Amount" />
                </div>

                <div class="col-md-6">
                    <x-input-form :value="$basket->discount_percentage" :required="false" type="number" id="discount"
                        name="discount_percentage" label="Discount Percentage" />
                </div>

                <div class="col-md-12">
                    <x-status :value="$basket->status" />
                </div>

            </div>
        </div>

        <x-btn-submit :update="true" />
    </form>
</div>
@endsection