@extends('layouts.admin')

@section('title', 'Create Basket Plan')

@section('content')
<div class="card">

    <form method="POST" action="{{ route('basket.store') }}" enctype="multipart/form-data">
        @csrf
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 text-center mb-5">
                    <img id="imgProduct" src="{{ env('BLANK_IMAGE') }}" style="height: 100px; border-radius: 4px;">
                </div>

                <div class="col-md-6">
                    <x-input-file id="inputProduct" label="Select a Image" img="imgProduct" />
                </div>

                <div class="col-md-6">
                    <x-input-form id="name" name="name" label="Name" />
                </div>

                <div class="col-md-6">
                    <x-input-select label="Duration" name="duration" id="duration">
                        <option value="7">7 Days</option>
                        <option value="30">30 Days</option>
                    </x-input-select>
                </div>

                <div class="col-md-6">
                    <x-input-form type="number" id="mrp" name="min_amount" label="Min Amount" />
                </div>

                <div class="col-md-6">
                    <x-input-form type="number" id="discount" name="discount_percentage"
                        label="Discount Percentage" />
                </div>

                <div class="col-md-12">
                    <x-status />
                </div>

            </div>
        </div>

        <div class="card-footer">
            <button type="submit" class="btn btn-success btn-block">CREATE</button>
        </div>
    </form>
</div>
@endsection