<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->unique();

            $table->string('name');
            $table->string('image')->nullable();

            $table->string('payment_method')->default('');
            $table->string('payment_status')->default('unpaid');
            $table->string('payment_id')->nullable();
            $table->string('payment_order_id')->nullable();

            $table->float('mrp')->default(0);
            $table->double('discount')->default(0);
            $table->float('total')->default(0);

            $table->string('type');

            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            $table->boolean('women_delivery')->default(false);

            $table->boolean('confirmed')->default(false);

            $table->foreignId('customer_id');
            $table->foreignId('address_id')->nullable();
            $table->foreignId('package_id')->nullable();
            $table->foreignId('basket_id')->nullable();
            $table->foreignId('vendor_id')->nullable();
            $table->foreignId('donation_id')->nullable();

            $table->string('status')->default('processing');
            $table->boolean('verified')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
