<?php

namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;

class FileService
{
    public function store(string $key, string $path)
    {
        if (!request()->hasFile($key)) return false;

        return request()->file($key)->storePublicly($path, 'public');
    }

    public function checkAndStore(string $imgKey, string $path, $storedPath)
    {
        if (!request()->hasFile($imgKey)) return $storedPath;

        $this->delete($storedPath);

        return $this->store($imgKey, $path);
    }

    public function resize(string $key, string $path, int $width = 100, int $height = 100)
    {
        if (!request()->hasFile($key)) return false;

        $original = request()->file($key);
        $modifiable = Image::make($original);

        $modifiable->resize($width, $height, function ($constraint) {
            $constraint->aspectRatio();
        })->save();

        return $original->storePublicly($path, 'public');
    }

    public function delete($path, string $disk = 'public')
    {
        if ($path == null) return true;

        return Storage::disk($disk)->delete($path);
    }

    public function url(string $path)
    {
        return asset('storage/' . $path);
    }
}
