<?php

namespace App\Models\Wallets;

use App\Casts\Money;
use App\Models\User;
use App\Shared\Active;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * @property array{currency: string, amount: float} $balance
 * @property array{currency: string, amount: float} $reserve
 * @property array{currency: string, amount: float} $coupon
 * @property array{currency: string, amount: float} $debt
 * @property array{currency: string, amount: float} $max_debt
 * @property array{currency: string, amount: float} $package
 * @property integer $user_id
 * @property-read User $user
 * @property-read  Collection|Transaction[] $transactions
 */
class Wallet extends Model
{
    use HasFactory, Active;

    protected $fillable = [
        'balance',
        'reserve',
        'coupon',
        'debt',
        'max_debt',
        'package',

        'user_id',
    ];

    protected $with = ['transactions'];

    protected $casts = [
        'balance' => Money::class,
        'reserve' => Money::class,
        'coupon' => Money::class,
        'debt' => Money::class,
        'max_debt' => Money::class,
        'package' => Money::class,
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(Transaction::class, 'wallet_id');
    }
}
