<?php

namespace App\Models;

use App\Models\Orders\Order;
use App\Models\Wallets\Transaction;
use App\Models\Wallets\Wallet;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

/**
 * Class User
 * @package App\Models
 * @property-read Wallet $wallet
 */
class User extends Authenticatable
{
    use HasApiTokens, HasRoles, Notifiable, HasFactory;

    const MERCHANT_STORE = 'store';
    const MERCHANT_KISHAN = 'kishan';
    const MERCHANT_MERCHANT = 'merchant';

    protected $fillable = [
        'name',
        'phone',
        'email',
        'password',

        'merchant_type',

        'employer_id',
        'postcode',

        'image',
        'aadhaar_front',
        'aadhaar_back',

        'status',
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public function wallet(): HasOne
    {
        return $this->hasOne(Wallet::class, 'user_id');
    }

    public function transactions(): HasMany
    {
        return $this->hasMany(Transaction::class, 'user_id');
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class, 'customer_id');
    }
}
