<?php

namespace App\Models\Products;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductRequirement extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'variant_id',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id')->with(['category', 'subcategory', 'brand']);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class, 'variant_id');
    }
}
