<?php

namespace App\Models\Products;

use App\Models\Brands\Brand;
use App\Models\Categories\Category;
use App\Shared\Active;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Product extends Model
{
    use HasFactory, Active;

    protected $fillable = [
        'name',
        'image',
        'description',

        'status',

        'in_stock',

        'place',

        'category_id',
        'subcategory_id',
        'brand_id',
        'vendor_id',

        'sort',
    ];

    protected $appends = ['in_cart'];

    protected $casts = [
        'in_stock' => 'boolean',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function subcategory(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'subcategory_id');
    }

    public function variants(): HasMany
    {
        return $this->hasMany(Variant::class, 'product_id');
    }

    public function brand(): BelongsTo
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }

    public function getInCartAttribute(): bool
    {
        if (!auth()->check()) return false;

        return true;
    }

    public function scopeRelations($query)
    {
        return $query->with('category', 'subcategory', 'variants', 'brand');
    }

    public function scopeSafe($query)
    {
        return $query
            ->has('variants')
            ->has('category')
            ->has('brand')
            ->has('subcategory')
            ->relations();
    }
}
