<?php

namespace App\Models\Packages;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PackageGroup extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'sort',
        'status',
    ];

    public function packages(): HasMany
    {
        return $this->hasMany(Package::class, 'group_id');
    }
}
