<?php

namespace App\Models\Packages;

use App\Models\Orders\Order;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Basket extends Model
{
    use HasFactory;

    protected $fillable = [
        'image',
        'name',
        'duration',
        'min_amount',
        'discount_percentage',
        'status',
    ];

    protected $appends = [
        'is_active', 'order',
    ];

    public function getIsActiveAttribute(): bool
    {
        return $this->getOrder() !== null;
    }

    public function getOrderAttribute()
    {
        $order = $this->getOrder();

        if (!isset($order)) return null;

        return $order;
    }

    protected function getOrder()
    {
        if (auth('sanctum')->user() == null) return false;

        $id = auth('sanctum')->id();

        if (!isset($id)) return null;

        $order = Order::query()
            ->where('status', '!=', Order::ORDER_PENDING)
            ->where('customer_id', $id)
            ->where('basket_id', $this->id)
            ->where('end_date', '>=', date('Y-m-d'))
            ->first();

        if (!isset($order)) return null;

        return $order;
    }
}
