<?php

namespace App\Models\Orders;

use App\Models\Products\Product;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OrderProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'product_id',
        'total_unit',
        'price',
    ];

    public function product(): BelongsTo
    {
        return $this
            ->belongsTo(Product::class, 'product_id')
            ->with('category', 'subcategory', 'variants', 'brand');
    }

    public function variations(): HasMany
    {
        return $this
            ->hasMany(OrderVariation::class, 'order_product_id');
    }
}
