<?php

namespace App\Models\Carts\Services;

use App\Models\Carts\Cart;

class CartService
{
    public function updatePrice(Cart $cart)
    {
        $variant = $cart->variant;
        $quantity = $cart->quantity;

        $data = ['mrp' => 0];

        if ($variant->discount_type != 'none') {
            $data['mrp'] = $variant->mrp['amount'] * $quantity;
        }

        $data['price'] = $variant->price['amount'] * $quantity;

        $cart->update($data);
    }
}
