<?php

namespace App\Models\Carts;

use App\Casts\Money;
use App\Models\Products\Product;
use App\Models\Products\Variant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Cart extends Model
{
    use HasFactory;

    protected $fillable = [
        'quantity',
        'mrp',
        'price',
        'customer_id',
        'product_id',
        'variant_id',
    ];

    protected $casts = [
        'mrp' => Money::class,
        'price' => Money::class,
    ];

    public function product(): BelongsTo
    {
        return $this
            ->belongsTo(Product::class, 'product_id')
            ->with(['category', 'subcategory', 'brand']);
    }

    public function variant(): BelongsTo
    {
        return $this
            ->belongsTo(Variant::class, 'variant_id');
    }
}
