<?php

namespace App\Http\Resources\Package;

use App\Casts\Money;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'image' => $this->image,
            'banner' => $this->banner,
            'duration' => $this->duration,
            'discount_type' => $this->discount_type,
            'discount' => $this->discount,
            'discount_amount' => Money::format($this->mrp - $this->price),
            'mrp' => Money::format($this->mrp),
            'price' => Money::format($this->price),
        ];
    }
}
