<?php

namespace App\Http\Resources\Package;

use App\Casts\Money;
use App\Http\Resources\Product\ProductResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PackageProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'total_unit' => $this->total_unit,
            'price' => Money::format($this->price),
            'product' => ProductResource::make($this->product),
            'variations' => PackageVariationResource::collection($this->variations),
        ];
    }
}
