<?php

namespace App\Http\Resources\Order;

use App\Http\Resources\Product\VariantResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderVariantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'remaining_quantity' => $this->remaining_quantity,
            'total' => $this->total,
            'variant' => VariantResource::make($this->variant),
        ];
    }
}
