<?php

namespace App\Http\Resources\Order;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'order_id' => $this->order_id,

            'name' => $this->name,
            'image' => $this->image,

            'status' => $this->status,

            'mrp' => $this->mrp,
            'discount' => $this->discount,
            'total' => $this->total,

            'duration' => $this->duration,

            'can_cancel' => $this->can_cancel,
            'show_confirm' => $this->show_confirm,
            'confirmed' => $this->confirmed,
        ];
    }
}
