<?php

namespace App\Http\Resources\Order;

use App\Http\Resources\Product\ProductResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'total_unit' => $this->total_unit,
            'price' => $this->price,
            'product' => ProductResource::make($this->whenLoaded('product')),
            'variations' => OrderVariantResource::collection($this->whenLoaded('variations')),
        ];
    }
}
