<?php

namespace App\Http\Resources\Delivery;

use App\Casts\Money;
use App\Http\Resources\Address\AddressResource;
use App\Http\Resources\Customer\CustomerResource;
use App\Http\Resources\Product\ProductResource;
use App\Http\Resources\Product\VariantResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DeliveryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'time' => $this->time,
            'date' => $this->date,
            'status' => $this->status,
            'customer' => CustomerResource::make($this->whenLoaded('customer')),
            'address' => AddressResource::make($this->whenLoaded('address')),
            'product' => ProductResource::make($this->whenLoaded('product')),
            'variant' => VariantResource::make($this->variation->variant),
            'price' => Money::format($this->variant->price['amount'] * $this->quantity),
        ];
    }
}
