<?php

namespace App\Http\Resources\Delivery;

use App\Casts\Money;
use App\Http\Resources\Address\AddressResource;
use App\Http\Resources\Customer\CustomerResource;
use App\Http\Resources\Product\ProductResource;
use App\Http\Resources\Product\VariantResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DeliveryPartnerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            'id' => $this->id,

            'quantity' => $this->quantity,
            'unit' => $this->variant->unit,
            'price' => $this->variant->price['amount'] * $this->quantity,

            'time' => $this->time,
            'date' => $this->date,
            'status' => $this->status,

            'product' => [
                'brand' => $this->product->brand->name ?? '',
                'name' => $this->product->name,
                'image' => $this->product->image,
            ],
        ];
    }
}
