<?php

namespace App\Http\Livewire\Wallet;

use App\Models\Wallets\Transaction;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class TransactionsTable extends DataTableComponent
{
    public int $walletId;

    public function columns(): array
    {
        return [
            Column::make('AMOUNT', 'amount')->format(function ($value) {
                return $value['currency'];
            }),

            Column::make('TYPE', 'type'),

            Column::make('TIME', 'created_at')->format(function ($value) {
                return $value->format('h:i A');
            }),

            Column::make('DATE', 'created_at')->format(function ($value) {
                return $value->format('d-m-Y');
            }),
        ];
    }

    public function query(): Builder
    {
        return Transaction::query()
            ->where('wallet_id', $this->walletId)
            ->latest();
    }
}
