<?php

namespace App\Http\Livewire;

use App\Models\Brands\Brand;
use App\Models\Categories\Category;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\Products\Product;
use Rappasoft\LaravelLivewireTables\Views\Filter;

class ProductDatatable extends DataTableComponent
{
    public function columns(): array
    {
        return [
            Column::make('NAME', 'name')->format(function ($value, $column, $row) {
                return view('admin.shared.image')->with([
                    'name' => $value,
                    'image' => $row->image,
                ]);
            })->searchable()->sortable(),

            Column::make('CATEGORY', 'category.name')->searchable(),
            Column::make('CATEGORY', 'category.name')->searchable(),
            Column::make('SUBCATEGORY', 'subcategory.name')->searchable(),
            Column::make('STATUS', 'status'),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.products.action', compact('row'));
            }),
        ];
    }

    public function filters(): array
    {
        $all = ['' => 'All'];

        $categories = Category::query()
            ->whereNull('parent_id')
            ->get()
            ->add(['id' => '', 'name' => 'All'])
            ->pluck('name', 'id')
            ->all();

        $brands = Brand::query()
            ->get()
            ->pluck('name', 'id')
            ->all();

        return [
            'category' => Filter::make('Category')->select(array_replace($all, $categories)),
            'brand' => Filter::make('Brand')->select(array_replace($all, $brands)),
        ];
    }

    public function query(): Builder
    {
        return Product::query()
            ->latest()
            ->with(['category', 'subcategory', 'brand'])
            ->withCount('variants')
            ->when($this->getFilter('category'), function ($query, $category) {
                return $query->where('category_id', $category);
            })
            ->when($this->getFilter('brand'), function ($query, $brand) {
                return $query->where('brand_id', $brand);
            });
    }
}
