<?php

namespace App\Http\Livewire;

use App\Models\Pincodes\Pincode;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class PostTable extends DataTableComponent
{

    public function columns(): array
    {
        return [
            Column::make('ID', 'id'),
            Column::make('POST', 'pincode'),
            Column::make('AREAS')->format(function ($value, $column, $row) {
                return count($row->areas ?? []);
            }),
            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.pincode.action', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return Pincode::query()
            ->latest();
    }
}
