<?php

namespace App\Http\Livewire\Payout;

use App\Models\Payouts\Payout;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class PayoutTable extends DataTableComponent
{

    public function columns(): array
    {
        return [
            Column::make('NAME', 'name')->format(function ($value) {
                return view('admin.shared.avatar')->with(['name' => $value]);
            })->searchable(),

            Column::make('AMOUNT', 'amount'),

            Column::make('ACCOUNT', 'account'),

            Column::make('IFSC', 'ifsc'),

            Column::make('DATE', 'created_at')->format(function ($value) {
                return $value->diffForHumans();
            }),

            Column::make('STATUS', 'status')->format(function ($value) {
                return view('admin.payouts.status', compact('value'));
            }),

            Column::make('ACTIONS')->format(function ($value, $column, $row) {
                return view('admin.payouts.action', compact('row'));
            }),
        ];
    }

    public function query(): Builder
    {
        return Payout::query()
            ->latest();
    }
}
