<?php

namespace App\Http\Controllers\Admin\Wallet;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Models\Wallets\Wallet;

class WalletController extends Controller
{
    public function show(User $user)
    {
        $wallet = $user->wallet;

        return view('admin.wallet.show', compact('wallet'));
    }

    public function recharge(Request $request, Wallet $wallet): RedirectResponse
    {
        $this->transaction->recharge($request['amount'], $wallet);

        return back()->with('success', 'Recharge Successfully!');
    }

    public function coupon(Request $request, Wallet $wallet): RedirectResponse
    {
        $wallet->update(['coupon' => $request['amount'] + $wallet->coupon['amount']]);

        return back()->with('success', 'Coupon Added Successfully!');
    }

    public function debt(Request $request, Wallet $wallet): RedirectResponse
    {
        $wallet->update(['max_debt' => $request['amount']]);

        return back()->with('success', 'Max Debt Set Successfully!');
    }

    public function package(Request $request, Wallet $wallet): RedirectResponse
    {
        $amount = $request['amount'];

        if ($amount > $wallet->package['amount']) {
            return back()->with('error', 'Unable to transfer package!');
        }

        $query = Wallet::query()
            ->where('id', $wallet->id);

        $query->decrement('package', $amount);
        $query->increment('coupon', $amount);

        return back()->with('success', 'Package Transfer Success!');
    }
}
