<?php

namespace App\Http\Controllers\Admin\Vendor;

use App\DataTables\VendorDatatable;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;


class VendorController extends Controller
{
    public function index(VendorDatatable $table)
    {
        return $table->render('admin.vendor.index');
    }

    public function create()
    {
        return view('admin.vendor.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'phone' => "required|unique:users",
            'password' => "required",
            'merchant_type' => "required",
        ]);

        $data['password'] = Hash::make($data['password']);

        User::query()->create($data)->assignRole('merchant');


        return redirect()->route('vendors.index')->with('success', 'Customer Created Successfully!');
    }

    public function edit(User $vendor)
    {
        return view('admin.vendor.edit', compact('vendor'));
    }

    public function update(Request $request, User $vendor)
    {
        $data = $request->all();

        $request->validate([
            'name' => 'required',
            'email' => "required|email|unique:users,email,$vendor->id",
            'phone' => "required|unique:users,phone,$vendor->id",
        ]);

        if (isset($data['password'])) {
            $data['password'] = Hash::make($data['password']);
        } else {
            unset($data['password']);
        }

        $vendor->update($data);

        return redirect()->route('vendors.index')->with('success', 'Vendor Updated Successfully');
    }

    public function destroy(User $vendor)
    {
        $vendor->delete();

        return back()->with('info', 'Vendor Deleted!');
    }
}
