<?php

namespace App\Http\Controllers\Admin\Slider;

use Illuminate\Http\Request;
use App\Models\Sliders\Slider;
use App\Http\Controllers\Controller;

class SliderController extends Controller
{
    public function index()
    {
        $sliders = Slider::whereParentId(null)->get();

        return view('admin.sliders.index', compact('sliders'));
    }

    public function create()
    {
        return view('admin.sliders.create');
    }


    public function store(Request $request)
    {
        $data = $request->all();
        Slider::create($data);

        return redirect()->route('sliders.index')->with('success', 'Slider added Successfully!');
    }

    public function show(Slider $slider)
    {
        $child = $slider->child;

        return view('admin.sliders.child.index', compact('slider', 'child'));
    }

    public function edit(Slider $slider)
    {
        return view('admin.sliders.edit', compact('slider'));
    }

    public function update(Request $request, Slider $slider)
    {
        $data = $request->all();
        $slider->update($data);

        return redirect()->route('sliders.index')->with('success', 'Slider Updated Successfully!');
    }

    public function destroy(Slider $slider)
    {
        $this->fileService->delete($slider->image);
        $slider->delete();

        return redirect()->route('sliders.index')->with('info', 'Slider Deleted Successfully');
    }
}
