<?php

namespace App\Http\Controllers\Admin\Profile;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function edit()
    {
        $profile = auth()->user();

        return view('admin.profile.edit', compact('profile'));
    }

    public function update(Request $request, User $profile)
    {
        $data = $request->all();

        if (isset($data['password'])) {
            $password = Hash::make($data['password']);
            $profile->update(['password' => $password]);
        } else {
            $profile->update($data);
        }

        return back()->with('success', 'Profile Update Successfully');
    }
}
