<?php

namespace App\Http\Controllers\Admin\ProductVendor;

use App\Models\Brands\Brand;
use Illuminate\Http\Request;
use App\Models\Products\Product;
use App\Models\Categories\Category;
use App\Http\Controllers\Controller;

class ProductVendorController extends Controller
{
    public function index()
    {
        $products = Product::whereNotNull('vendor_id')->paginate(10);

        return view('admin.vendorproduct.index', compact('products'));
    }

    public function create()
    {
        $category = Category::whereParentId(null)->with('child')->get();
        $brand = Brand::whereStatus('Active')->get();

        return view('admin.products.create', compact('category', 'brand'));
    }

    public function store(Request $request)
    {
        $data = $request->all();
        $data['category_id'] = json_decode($data['category_id'])->id;
        $data['image'] = $this->fileService->store('image', 'products');

        Product::create($data);

        return redirect()->route('products.index')->with('success', 'Product Inserted Successfully');
    }

    public function edit(Product $product)
    {
        $category = Category::whereParentId(null)->with('child')->get();
        $brand = Brand::whereStatus('Active')->get();

        $subcategory = Category::where(['parent_id' => $product->category_id])->get();

        return view('admin.products.edit', compact('product', 'category', 'brand', 'subcategory'));
    }

    public function update(Request $request, Product $product)
    {
        $data = $request->all();

        $data['category_id'] = json_decode($data['category_id'])->id;
        $data['image'] = $this->fileService->checkAndStore('image', 'products', $product->image);

        $product->update($data);

        return redirect()->route('products.index')->with('success', 'Product Updated Successfully');
    }

    public function destroy($id)
    {
        //
    }
}
