<?php

namespace App\Http\Controllers\Admin\Product;

use App\DataTables\ProductRequirementDataTable;
use App\Http\Controllers\Controller;
use App\Models\Products\Product;
use App\Models\Products\ProductRequirement;
use Illuminate\Http\Request;

class ProductRequirementController extends Controller
{
    public function index(ProductRequirementDataTable $table)
    {
        $products = Product::with('variants')->get();

        return $table->render('admin.products.requirement.index', compact('products'));
    }

    public function store(Request $request)
    {
        ProductRequirement::create($request->all());
    }

    public function destroy(ProductRequirement $requirement)
    {
        $requirement->delete();

        return back()->with('info', 'Requirement Deleted!');
    }
}
