<?php

namespace App\Http\Controllers\Admin\Product;

use App\DataTables\ProductDataTable;
use App\Models\Brands\Brand;
use Illuminate\Http\Request;
use App\Models\Products\Product;
use App\Models\Categories\Category;
use App\Http\Controllers\Controller;

class ProductController extends Controller
{
    public function index(ProductDataTable $table)
    {
        return $table->render('admin.products.index');
    }

    public function create()
    {
        $category = Category::whereParentId(null)->with('child')->get();
        $brand = Brand::whereStatus('Active')->get();

        return view('admin.products.create', compact('category', 'brand'));
    }

    public function store(Request $request)
    {
        $data = $request->all();

        $request->validate([
            'image' => 'required|image',
            'name' => 'required',
            'brand_id' => 'required',
            'sort' => 'required',
            'description' => 'required',
        ]);

        $data['image'] = $this->fileService->store('image', 'products');

        Product::query()->create($data);

        return redirect()->route('products.index')->with('success', 'Product Inserted Successfully');
    }

    public function edit(Product $product)
    {
        $brand = Brand::whereStatus('Active')->get();

        return view('admin.products.edit', compact('product', 'brand'));
    }

    public function update(Request $request, Product $product)
    {
        $data = $request->all();

        $request->validate([
            'image' => 'image',
            'name' => 'required',
            'brand_id' => 'required',
            'sort' => 'required',
            'description' => 'required',
        ]);

        $data['image'] = $this->fileService->checkAndStore('image', 'products', $product->image);

        $product->update($data);

        return redirect()->to($data['url'])->with('success', 'Product Updated Successfully');
    }

    public function destroy(Product $product)
    {
        $this->fileService->delete($product->image);
        $product->delete();

        return redirect()->route('products.index')->with('info', 'Product Deleted!');
    }
}
