<?php

namespace App\Http\Controllers\Admin\Payout;

use App\Http\Controllers\Controller;
use App\Models\Payouts\Payout;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class PayoutController extends Controller
{

    public function index()
    {
        return view('admin.payouts.index');
    }

    public function edit(Payout $payout)
    {
        $status = [
            Payout::PENDING,
            Payout::COMPLETED,
            Payout::CANCELLED,
        ];

        return view('admin.payouts.edit', compact('payout', 'status'));
    }

    public function update(Request $request, Payout $payout): RedirectResponse
    {
        $data = $request->validate([
            'status' => 'required',
        ]);

        $payout->update($data);

        return redirect()->route('payouts.index')->with('success', 'Change Status!');
    }


    public function destroy(Payout $payout): RedirectResponse
    {
        $payout->delete();

        return back()->with('info', 'Deleted Successfully!');
    }
}
