<?php

namespace App\Http\Controllers\Admin\Package;

use App\DataTables\PackageGroupDataTable;
use App\Http\Controllers\Controller;
use App\Models\Packages\PackageGroup;
use Illuminate\Http\Request;

class PackageGroupController extends Controller
{
    public function index(PackageGroupDataTable $table)
    {
        return $table->render('admin.package.group.index');
    }

    public function create()
    {
        return view('admin.package.group.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);

        $data = $request->all();

        if (!isset($data['sort'])) {
            unset($data['sort']);
        }

        PackageGroup::query()->create($data);

        return redirect()->route('group.index')->with('success', 'Group Created!');
    }


    public function edit(PackageGroup $group)
    {
        return view('admin.package.group.edit', compact('group'));
    }

    public function update(Request $request, PackageGroup $group)
    {
        $request->validate([
            'name' => 'required',
            'status' => 'required',
        ]);

        $data = $request->all();

        if (!isset($data['sort'])) {
            unset($data['sort']);
        }

        $group->update($data);

        return redirect()->route('group.index')->with('success', 'Group Updated!');
    }


    public function destroy(PackageGroup $group)
    {
        $group->delete();

        return redirect()->route('group.index')->with('success', 'Group Deleted!');
    }
}
